<!-- Dashboard Statistics Cards -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.umd.js"></script>

<style>
    /* Enhanced Dashboard Styling */
    .stats-card {
        background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
        border: 1px solid #e9ecef;
        border-radius: 12px;
        padding: 1.5rem;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        overflow: hidden;
    }
    
    .stats-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: linear-gradient(90deg, var(--primary-color), var(--accent-2));
    }
    
    .stats-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.08);
        border-color: var(--primary-color);
    }
    
    .stats-card p {
        color: #6c757d;
        font-size: 0.9rem;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 0.5rem;
    }
    
    .stats-card h3 {
        font-size: 2.5rem;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 0.25rem;
    }
    
    .stats-card small {
        font-size: 0.85rem;
    }
    
    .stats-card i {
        transition: all 0.3s ease;
    }
    
    .stats-card:hover i {
        transform: scale(1.1) rotate(-10deg);
        opacity: 0.5 !important;
    }
    
    .stats-card .btn {
        border-radius: 8px;
        font-size: 0.85rem;
        font-weight: 600;
        transition: all 0.3s ease;
    }
    
    .stats-card .btn:hover {
        transform: translateX(4px);
    }
    
    /* Table Card Enhancement */
    .table-card {
        background: white;
        border: 1px solid #e9ecef;
        border-radius: 12px;
        padding: 1.75rem;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.04);
        transition: all 0.3s ease;
    }
    
    .table-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.08);
    }
    
    .table-card h5 {
        color: #231f20;
        font-weight: 700;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f0f0f0;
    }
    
    .table-card h5 i {
        color: var(--primary-color);
        font-size: 1.25rem;
    }
    
    /* Chart Container */
    .chart-container {
        position: relative;
        height: 350px;
        margin-bottom: 1rem;
    }
    
    /* List Group Enhancement */
    .list-group-item {
        border: none;
        padding: 1rem 0;
        border-bottom: 1px solid #f0f0f0;
        transition: all 0.3s ease;
    }
    
    .list-group-item:last-child {
        border-bottom: none;
    }
    
    .list-group-item:hover {
        background-color: #f8f9fa;
        padding-left: 0.5rem;
    }
    
    .list-group-item-action {
        cursor: pointer;
        border-left: 3px solid transparent;
        transition: all 0.3s ease;
    }
    
    .list-group-item-action:hover {
        border-left-color: var(--primary-color);
        background-color: #f8f9fa;
    }
    
    /* Badge Styling */
    .badge {
        font-weight: 600;
        padding: 0.5rem 0.75rem;
        border-radius: 6px;
        font-size: 0.8rem;
        text-transform: uppercase;
        letter-spacing: 0.3px;
    }
    
    /* Table Enhancement */
    .table {
        margin-bottom: 0;
    }
    
    .table thead th {
        background-color: #f8f9fa;
        border-bottom: 2px solid #e9ecef;
        font-weight: 700;
        color: #231f20;
        text-transform: uppercase;
        font-size: 0.85rem;
        letter-spacing: 0.5px;
        padding: 1rem 0.75rem;
    }
    
    .table tbody tr {
        transition: all 0.3s ease;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .table tbody tr:hover {
        background-color: #f8f9fa;
        transform: scale(1.01);
    }
    
    .table tbody td {
        vertical-align: middle;
        padding: 1rem 0.75rem;
        color: #495057;
    }
    
    /* Section Divider */
    .section-divider {
        margin: 3rem 0 2rem 0;
        padding-top: 2rem;
        border-top: 2px solid #f0f0f0;
    }
    
    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 3rem 1rem;
        color: #6c757d;
    }
    
    .empty-state i {
        font-size: 3rem;
        color: #dee2e6;
        margin-bottom: 1rem;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .stats-card {
            margin-bottom: 1rem;
        }
        
        .chart-container {
            height: 250px;
        }
        
        .table-responsive {
            font-size: 0.9rem;
        }
    }
</style>

<!-- Dashboard Statistics Cards -->
<div class="row mb-4">
    <!-- Blog Posts -->
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stats-card">
            <div class="d-flex justify-content-between align-items-start">
                <div class="flex-grow-1">
                    <p class="mb-1">📝 Blog Posts</p>
                    <h3 class="mb-2"><?php echo $stats['published_posts']; ?></h3>
                    <small class="text-muted"><i class="fas fa-file-alt"></i> <?php echo $stats['draft_posts']; ?> drafts pending</small>
                </div>
                <i class="fas fa-newspaper fa-2x" style="color: #f26124; opacity: 0.2;"></i>
            </div>
            <div class="mt-3">
                <a href="<?php echo base_url('admin/blog'); ?>" class="btn btn-sm btn-outline-primary w-100">
                    <i class="fas fa-arrow-right"></i> Manage Posts
                </a>
            </div>
        </div>
    </div>
    
    <!-- Volunteers -->
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stats-card" style="--primary-color: #28a745;">
            <div class="d-flex justify-content-between align-items-start">
                <div class="flex-grow-1">
                    <p class="mb-1">👥 Volunteers</p>
                    <h3 class="mb-2" style="color: #28a745;"><?php echo $stats['active_volunteers']; ?></h3>
                    <small class="text-muted">
                        <?php if($stats['pending_volunteers'] > 0): ?>
                            <i class="fas fa-hourglass-end text-warning"></i> <?php echo $stats['pending_volunteers']; ?> pending review
                        <?php else: ?>
                            <i class="fas fa-check-circle text-success"></i> All reviewed
                        <?php endif; ?>
                    </small>
                </div>
                <i class="fas fa-users fa-2x" style="color: #28a745; opacity: 0.2;"></i>
            </div>
            <div class="mt-3">
                <a href="<?php echo base_url('admin/volunteers'); ?>" class="btn btn-sm btn-outline-success w-100">
                    <i class="fas fa-arrow-right"></i> View Applications
                </a>
            </div>
        </div>
    </div>
    
    <!-- Consultations -->
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stats-card" style="--primary-color: #8105bf;">
            <div class="d-flex justify-content-between align-items-start">
                <div class="flex-grow-1">
                    <p class="mb-1">📅 Consultations</p>
                    <h3 class="mb-2" style="color: #8105bf;"><?php echo $stats['scheduled_consultations']; ?></h3>
                    <small class="text-muted">
                        <?php if($stats['new_consultations'] > 0): ?>
                            <i class="fas fa-star text-info"></i> <?php echo $stats['new_consultations']; ?> new requests
                        <?php else: ?>
                            <i class="fas fa-check text-success"></i> All handled
                        <?php endif; ?>
                    </small>
                </div>
                <i class="fas fa-calendar-check fa-2x" style="color: #8105bf; opacity: 0.2;"></i>
            </div>
            <div class="mt-3">
                <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-sm btn-outline-secondary w-100">
                    <i class="fas fa-arrow-right"></i> Manage Bookings
                </a>
            </div>
        </div>
    </div>
    
    <!-- Messages -->
    <div class="col-xl-3 col-md-6 mb-3">
        <div class="stats-card" style="--primary-color: #dc3545;">
            <div class="d-flex justify-content-between align-items-start">
                <div class="flex-grow-1">
                    <p class="mb-1">💬 Messages</p>
                    <h3 class="mb-2" style="color: #dc3545;"><?php echo $stats['total_messages']; ?></h3>
                    <small class="text-muted">
                        <?php if($stats['unread_messages'] > 0): ?>
                            <i class="fas fa-envelope text-danger"></i> <?php echo $stats['unread_messages']; ?> unread
                        <?php else: ?>
                            <i class="fas fa-check-double text-success"></i> All read
                        <?php endif; ?>
                    </small>
                </div>
                <i class="fas fa-envelope fa-2x" style="color: #dc3545; opacity: 0.2;"></i>
            </div>
            <div class="mt-3">
                <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-sm btn-outline-danger w-100">
                    <i class="fas fa-arrow-right"></i> View Messages
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row mb-4">
    <!-- Monthly Statistics Chart -->
    <div class="col-lg-8 mb-3">
        <div class="table-card">
            <h5><i class="fas fa-chart-line"></i> Monthly Activity Overview</h5>
            <div class="chart-container">
                <canvas id="monthlyStatsChart"></canvas>
            </div>
        </div>
    </div>
    
    <!-- Quick Stats -->
    <div class="col-lg-4 mb-3">
        <div class="table-card">
            <h5><i class="fas fa-lightning-bolt"></i> Quick Insights</h5>
            <div class="list-group list-group-flush">
                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                    <span><i class="fas fa-chalkboard-teacher" style="color: #f26124;"></i> Workshops</span>
                    <span class="badge bg-primary"><?php echo $stats['upcoming_workshops']; ?></span>
                </div>
                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                    <span><i class="fas fa-handshake" style="color: #28a745;"></i> Partners</span>
                    <span class="badge bg-success"><?php echo $stats['active_partners']; ?></span>
                </div>
                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                    <span><i class="fas fa-trophy" style="color: #8105bf;"></i> Completed</span>
                    <span class="badge bg-info"><?php echo $stats['completed_consultations']; ?></span>
                </div>
                <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                    <span><i class="fas fa-reply" style="color: #dc3545;"></i> Replied</span>
                    <span class="badge bg-warning"><?php echo $stats['replied_messages']; ?></span>
                </div>
            </div>
            <div class="mt-4">
                <a href="<?php echo base_url('admin/settings'); ?>" class="btn btn-sm btn-outline-secondary w-100">
                    <i class="fas fa-cog me-2"></i> System Settings
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activities Section -->
<div class="section-divider"></div>

<div class="row">
    <!-- Recent Consultations -->
    <div class="col-lg-4 mb-3">
        <div class="table-card">
            <h5><i class="fas fa-calendar-alt"></i> Recent Consultations</h5>
            <?php if(!empty($recent_consultations)): ?>
                <div class="list-group list-group-flush">
                    <?php foreach($recent_consultations as $consultation): ?>
                        <a href="<?php echo base_url('admin/consultations/view/' . $consultation->id); ?>" class="list-group-item list-group-item-action px-0 py-3">
                            <div class="d-flex w-100 justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1 fw-600"><?php echo character_limiter($consultation->full_name, 20); ?></h6>
                                    <p class="mb-2 small text-muted"><?php echo character_limiter($consultation->subject, 40); ?></p>
                                    <small><?php echo get_status_badge($consultation->status); ?></small>
                                </div>
                                <small class="text-muted text-nowrap ms-2"><?php echo time_ago($consultation->created_at); ?></small>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
                <div class="mt-3 pt-2 border-top">
                    <a href="<?php echo base_url('admin/consultations'); ?>" class="btn btn-sm btn-link text-primary">
                        View All Consultations <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-inbox"></i>
                    <p>No recent consultations</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Recent Volunteer Applications -->
    <div class="col-lg-4 mb-3">
        <div class="table-card">
            <h5><i class="fas fa-user-check"></i> Recent Volunteers</h5>
            <?php if(!empty($recent_volunteers)): ?>
                <div class="list-group list-group-flush">
                    <?php foreach($recent_volunteers as $volunteer): ?>
                        <a href="<?php echo base_url('admin/volunteers/view/' . $volunteer->id); ?>" class="list-group-item list-group-item-action px-0 py-3">
                            <div class="d-flex w-100 justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1 fw-600"><?php echo character_limiter($volunteer->full_name, 20); ?></h6>
                                    <p class="mb-2 small text-muted"><?php echo character_limiter($volunteer->occupation, 30); ?></p>
                                    <small><?php echo get_status_badge($volunteer->status); ?></small>
                                </div>
                                <small class="text-muted text-nowrap ms-2"><?php echo time_ago($volunteer->application_date); ?></small>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
                <div class="mt-3 pt-2 border-top">
                    <a href="<?php echo base_url('admin/volunteers'); ?>" class="btn btn-sm btn-link text-success">
                        View All Applications <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-users"></i>
                    <p>No recent applications</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Recent Messages -->
    <div class="col-lg-4 mb-3">
        <div class="table-card">
            <h5><i class="fas fa-envelope-open"></i> Recent Messages</h5>
            <?php if(!empty($recent_messages)): ?>
                <div class="list-group list-group-flush">
                    <?php foreach($recent_messages as $message): ?>
                        <a href="<?php echo base_url('admin/messages/view/' . $message->id); ?>" class="list-group-item list-group-item-action px-0 py-3">
                            <div class="d-flex w-100 justify-content-between align-items-start">
                                <div>
                                    <h6 class="mb-1 fw-600"><?php echo character_limiter($message->name, 20); ?></h6>
                                    <p class="mb-2 small text-muted"><?php echo character_limiter($message->subject, 40); ?></p>
                                    <small><?php echo get_status_badge($message->status); ?></small>
                                </div>
                                <small class="text-muted text-nowrap ms-2"><?php echo time_ago($message->created_at); ?></small>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
                <div class="mt-3 pt-2 border-top">
                    <a href="<?php echo base_url('admin/messages'); ?>" class="btn btn-sm btn-link text-danger">
                        View All Messages <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-mail-bulk"></i>
                    <p>No recent messages</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Upcoming Scheduled Consultations -->
<?php if(!empty($upcoming_scheduled)): ?>
<div class="section-divider"></div>
<div class="row">
    <div class="col-12">
        <div class="table-card">
            <h5><i class="fas fa-hourglass-start"></i> Upcoming Scheduled Consultations</h5>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th><i class="fas fa-user me-2"></i>Name</th>
                            <th><i class="fas fa-heading me-2"></i>Subject</th>
                            <th><i class="fas fa-calendar-days me-2"></i>Scheduled Date</th>
                            <th><i class="fas fa-user-tie me-2"></i>Assigned To</th>
                            <th style="width: 100px;"><i class="fas fa-cog me-2"></i>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($upcoming_scheduled as $scheduled): ?>
                        <tr>
                            <td><strong><?php echo $scheduled->full_name; ?></strong></td>
                            <td><?php echo character_limiter($scheduled->subject, 30); ?></td>
                            <td><span class="badge bg-light text-dark"><i class="fas fa-calendar me-1"></i><?php echo format_datetime($scheduled->scheduled_date); ?></span></td>
                            <td><?php echo $scheduled->assigned_to_name ? '<span class="badge bg-info">' . $scheduled->assigned_to_name . '</span>' : '<span class="text-muted">Unassigned</span>'; ?></td>
                            <td>
                                <a href="<?php echo base_url('admin/consultations/view/' . $scheduled->id); ?>" class="btn btn-sm btn-outline-primary" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Chart.js Script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.0.0/dist/chart.umd.min.js"></script>
<script>
    // Monthly Statistics Chart
    const ctx = document.getElementById('monthlyStatsChart');
    
    const monthlyData = <?php echo json_encode($monthly_stats); ?>;
    
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: monthlyData.map(item => item.month),
            datasets: [
                {
                    label: 'Volunteers',
                    data: monthlyData.map(item => item.volunteers),
                    borderColor: '#28a745',
                    backgroundColor: 'rgba(40, 167, 69, 0.08)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointBackgroundColor: '#28a745',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 7
                },
                {
                    label: 'Consultations',
                    data: monthlyData.map(item => item.consultations),
                    borderColor: '#8105bf',
                    backgroundColor: 'rgba(129, 5, 191, 0.08)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointBackgroundColor: '#8105bf',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 7
                },
                {
                    label: 'Messages',
                    data: monthlyData.map(item => item.messages),
                    borderColor: '#dc3545',
                    backgroundColor: 'rgba(220, 53, 69, 0.08)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointBackgroundColor: '#dc3545',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 7
                },
                {
                    label: 'Blog Posts',
                    data: monthlyData.map(item => item.blog_posts),
                    borderColor: '#f26124',
                    backgroundColor: 'rgba(242, 97, 36, 0.08)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointRadius: 5,
                    pointBackgroundColor: '#f26124',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointHoverRadius: 7
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        font: { weight: '600', size: 12 },
                        padding: 20,
                        boxWidth: 12,
                        borderRadius: 4
                    }
                },
                title: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        drawBorder: false,
                        color: '#f0f0f0'
                    },
                    ticks: {
                        precision: 0,
                        font: { weight: '500' }
                    }
                },
                x: {
                    grid: {
                        display: false,
                        drawBorder: false
                    },
                    ticks: {
                        font: { weight: '500' }
                    }
                }
            }
        }
    });
</script>